unit PersonForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.UmlRT,
  Borland.Eco.AutoContainers,
  Borland.Eco.Handles,

  CoreClassesUnit, MeetingManagerEcoSpace, Borland.Eco.WinForm;

type
  TPersonForm = class(System.Windows.Forms.Form, Borland.Eco.AutoContainers.IAutoContainer)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    TextBox1: System.Windows.Forms.TextBox;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    TextBox2: System.Windows.Forms.TextBox;
    Label3: System.Windows.Forms.Label;
    TextBox3: System.Windows.Forms.TextBox;
    ehMeetings: Borland.Eco.Handles.ExpressionHandle;
    TabControl1: System.Windows.Forms.TabControl;
    TabPage1: System.Windows.Forms.TabPage;
    ListBox1: System.Windows.Forms.ListBox;
    Button1: System.Windows.Forms.Button;
    EcoListActionExtender1: Borland.Eco.WinForm.EcoListActionExtender;
    EcoAutoFormExtender1: Borland.Eco.WinForm.EcoAutoFormExtender;
    ehresources: Borland.Eco.Handles.ExpressionHandle;
    TabPage2: System.Windows.Forms.TabPage;
    ListBox2: System.Windows.Forms.ListBox;
    Button2: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    procedure set_EcoSpace(Value: EcoSpace);
    constructor Create;
    procedure Show(autoContainerArgs: AutoContainerArgs);
    procedure BuildControls(element: IElement; autoContainerArgs: AutoContainerArgs);
    procedure HookUpGUI(ecoSpace: EcoSpace; element: IElement);
    property EcoSpace: EcoSpace write set_EcoSpace;    
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TPersonForm))]

	TPersonFormFactory = class(System.Object, Borland.Eco.AutoContainers.IAutoContainerFactory)
  private
    fPersonForm: TPersonForm;
  public
    function Matches(modelElement: IModelElement): boolean;
    function get_AutoContainer: IAutoContainer;
    property AutoContainer: IAutoContainer read get_AutoContainer;
  end;


implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TPersonForm.InitializeComponent;
begin
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.TextBox1 := System.Windows.Forms.TextBox.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.TextBox2 := System.Windows.Forms.TextBox.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.TextBox3 := System.Windows.Forms.TextBox.Create;
  Self.ehresources := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.TabControl1 := System.Windows.Forms.TabControl.Create;
  Self.TabPage1 := System.Windows.Forms.TabPage.Create;
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.ListBox1 := System.Windows.Forms.ListBox.Create;
  Self.TabPage2 := System.Windows.Forms.TabPage.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.ListBox2 := System.Windows.Forms.ListBox.Create;
  Self.ehMeetings := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.EcoListActionExtender1 := Borland.Eco.WinForm.EcoListActionExtender.Create;
  Self.EcoAutoFormExtender1 := Borland.Eco.WinForm.EcoAutoFormExtender.Create;
  Self.TabControl1.SuspendLayout;
  Self.TabPage1.SuspendLayout;
  Self.TabPage2.SuspendLayout;
  Self.SuspendLayout;
  // 
  // rhRoot
  // 
  Self.rhRoot.AddDefaultNestings := True;
  Self.rhRoot.EcoSpaceType := TypeOf(MeetingManagerEcoSpace.TMeetingManagerEcoSpace);
  Self.rhRoot.StaticValueTypeName := 'Person';
  // 
  // TextBox1
  // 
  Self.TextBox1.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextBox1.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.rhRoot, 'Name'));
  Self.TextBox1.Location := System.Drawing.Point.Create(96, 5);
  Self.TextBox1.Name := 'TextBox1';
  Self.TextBox1.Size := System.Drawing.Size.Create(184, 20);
  Self.TextBox1.TabIndex := 0;
  Self.TextBox1.Text := 'TextBox1';
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(16, 7);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(72, 16);
  Self.Label1.TabIndex := 1;
  Self.Label1.Text := 'Name: ';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(16, 29);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(72, 16);
  Self.Label2.TabIndex := 1;
  Self.Label2.Text := 'Location:';
  // 
  // TextBox2
  // 
  Self.TextBox2.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextBox2.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.rhRoot, 'Location'));
  Self.TextBox2.Location := System.Drawing.Point.Create(96, 29);
  Self.TextBox2.Name := 'TextBox2';
  Self.TextBox2.Size := System.Drawing.Size.Create(184, 20);
  Self.TextBox2.TabIndex := 0;
  Self.TextBox2.Text := 'TextBox1';
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(16, 55);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(72, 16);
  Self.Label3.TabIndex := 1;
  Self.Label3.Text := 'Address:';
  // 
  // TextBox3
  // 
  Self.TextBox3.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextBox3.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.rhRoot, 'Address'));
  Self.TextBox3.Location := System.Drawing.Point.Create(96, 53);
  Self.TextBox3.Name := 'TextBox3';
  Self.TextBox3.Size := System.Drawing.Size.Create(184, 20);
  Self.TextBox3.TabIndex := 0;
  Self.TextBox3.Text := 'TextBox1';
  // 
  // ehresources
  // 
  Self.ehresources.Expression := 'self.ownedResources';
  Self.ehresources.RootHandle := Self.rhRoot;
  // 
  // TabControl1
  // 
  Self.TabControl1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TabControl1.Controls.Add(Self.TabPage1);
  Self.TabControl1.Controls.Add(Self.TabPage2);
  Self.TabControl1.Location := System.Drawing.Point.Create(8, 80);
  Self.TabControl1.Name := 'TabControl1';
  Self.TabControl1.SelectedIndex := 0;
  Self.TabControl1.Size := System.Drawing.Size.Create(280, 192);
  Self.TabControl1.TabIndex := 2;
  // 
  // TabPage1
  // 
  Self.TabPage1.Controls.Add(Self.Button1);
  Self.TabPage1.Controls.Add(Self.ListBox1);
  Self.TabPage1.Location := System.Drawing.Point.Create(4, 22);
  Self.TabPage1.Name := 'TabPage1';
  Self.TabPage1.Size := System.Drawing.Size.Create(272, 166);
  Self.TabPage1.TabIndex := 0;
  Self.TabPage1.Text := 'Resources';
  // 
  // Button1
  // 
  Self.Button1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActionExtender1.SetBindingContext(Self.Button1, Self.ListBox1);
  Self.EcoListActionExtender1.SetEcoListAction(Self.Button1, Borland.Eco.WinForm.ListAction.Add);
  Self.Button1.ImageIndex := 1;
  Self.Button1.Location := System.Drawing.Point.Create(192, 136);
  Self.Button1.Name := 'Button1';
  Self.EcoListActionExtender1.SetRootHandle(Self.Button1, Self.ehresources);
  Self.Button1.TabIndex := 1;
  Self.Button1.Text := 'Add';
  // 
  // ListBox1
  // 
  Self.ListBox1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.ListBox1.DataSource := Self.ehresources;
  Self.ListBox1.DisplayMember := 'Name';
  Self.EcoAutoFormExtender1.SetEcoAutoForm(Self.ListBox1, True);
  Self.ListBox1.Location := System.Drawing.Point.Create(8, 8);
  Self.ListBox1.Name := 'ListBox1';
  Self.ListBox1.Size := System.Drawing.Size.Create(256, 108);
  Self.ListBox1.TabIndex := 0;
  // 
  // TabPage2
  // 
  Self.TabPage2.Controls.Add(Self.Button2);
  Self.TabPage2.Controls.Add(Self.ListBox2);
  Self.TabPage2.Location := System.Drawing.Point.Create(4, 22);
  Self.TabPage2.Name := 'TabPage2';
  Self.TabPage2.Size := System.Drawing.Size.Create(272, 166);
  Self.TabPage2.TabIndex := 1;
  Self.TabPage2.Text := 'Meetings';
  // 
  // Button2
  // 
  Self.Button2.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoListActionExtender1.SetBindingContext(Self.Button2, Self.ListBox2);
  Self.EcoListActionExtender1.SetEcoListAction(Self.Button2, Borland.Eco.WinForm.ListAction.Add);
  Self.Button2.ImageIndex := 1;
  Self.Button2.Location := System.Drawing.Point.Create(192, 136);
  Self.Button2.Name := 'Button2';
  Self.EcoListActionExtender1.SetRootHandle(Self.Button2, Self.ehMeetings);
  Self.Button2.TabIndex := 1;
  Self.Button2.Text := 'Add';
  // 
  // ListBox2
  // 
  Self.ListBox2.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.ListBox2.DataSource := Self.ehMeetings;
  Self.ListBox2.DisplayMember := 'Subject';
  Self.ListBox2.Location := System.Drawing.Point.Create(8, 8);
  Self.ListBox2.Name := 'ListBox2';
  Self.ListBox2.Size := System.Drawing.Size.Create(256, 108);
  Self.ListBox2.TabIndex := 0;
  // 
  // ehMeetings
  // 
  Self.ehMeetings.Expression := 'self.meetings';
  Self.ehMeetings.RootHandle := Self.rhRoot;
  // 
  // TPersonForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(292, 273);
  Self.Controls.Add(Self.TabControl1);
  Self.Controls.Add(Self.Label1);
  Self.Controls.Add(Self.TextBox1);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.TextBox2);
  Self.Controls.Add(Self.Label3);
  Self.Controls.Add(Self.TextBox3);
  Self.Name := 'TPersonForm';
  Self.Text := 'Information about a person...';
  Self.TabControl1.ResumeLayout(False);
  Self.TabPage1.ResumeLayout(False);
  Self.TabPage2.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TPersonForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TPersonForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

{ TPersonFormFactory }

function TPersonFormFactory.Get_AutoContainer: IAutoContainer;
begin
  if not Assigned(fPersonForm) or fPersonForm.Disposing or fPersonForm.IsDisposed then
    fPersonForm := TPersonForm.Create;
  fPersonForm.BringToFront;
  Result := fPersonForm as IAutoContainer;
end;

function TPersonFormFactory.Matches(modelElement: IModelElement): boolean;
begin
  Result := (modelElement is IClassifier) and
        (IClassifier(modelElement).ObjectType = typeof(Person));
end;

procedure TPersonForm.BuildControls(element: IElement;
  autoContainerArgs: AutoContainerArgs);
begin
  // form is already built in design time
end;

procedure TPersonForm.HookUpGUI(ecoSpace: EcoSpace; element: IElement);
begin
  rhRoot.SetElement(element);
end;

procedure TPersonForm.Show(autoContainerArgs: AutoContainerArgs);
begin
  if autoContainerArgs.ShowModal then
    ShowDialog
  else
    inherited Show;
	BringToFront;
end;

procedure TPersonForm.set_EcoSpace(Value: EcoSpace);
begin
  rhRoot.EcoSpace := Value;
end;

end.
